/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8275.BoxInfo;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class UnicastAddrCreate
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8275.GeneralResources");
    public static final int RASID = 19;
    public static final int RASSUB = 7;
    DestinationPropBook myBook;
    JdmBrowser browser;
    GenModel device_Model;
    NavigationContext myContext;
    BoxInfo boxInfo;
    MessageBox messageToUser;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        Hashtable hashtable = jDMWizardInfo.getItems();
        hashtable.remove("newMacAddress");
        hashtable.put("newSecurityMode", new Integer(1));
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl = true;
        GenModel genModel = null;
        ModelInfo modelInfo = null;
        Hashtable hashtable = null;
        Integer n = null;
        String string = null;
        Integer n2 = null;
        Integer n3 = null;
        OctetString octetString = null;
        String string2 = "proceed";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, this, string2);
        }
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string2, "Can't get browser- can't proceed with create");
            }
            bl = false;
        }
        if (this.boxInfo == null) {
            this.boxInfo = BoxInfo.getFromNavContext(this.myBook.getNavContext(), true);
        }
        if (bl) {
            hashtable = jDMWizardInfo.getItems();
            genModel = jDMWizardInfo.getModel();
            try {
                octetString = (OctetString)hashtable.get("newMacAddress");
                n3 = (Integer)hashtable.get("newVlanIdNum");
                n2 = (Integer)hashtable.get("newPortNum");
                n = (Integer)hashtable.get("newSecurityMode");
                if (n2 > this.boxInfo.getCurrentNumOfPorts() || n2 <= 0) {
                    if (RAS.isEnabled(19, 7)) {
                        RAS.trace(19, 7, this, string2, "invalid Port Num");
                    }
                    string = new String("UC_invalidPortNum");
                    bl = false;
                } else if (n3 <= 0) {
                    if (RAS.isEnabled(19, 7)) {
                        RAS.trace(19, 7, this, string2, "invalid Vlan Num");
                    }
                    string = new String("WZ_invalidVlan");
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string2, "unexpected/missing user data- can't create row");
                }
                RAS.logException(19, 7, this, string2, exception);
                string = new String("WZ_missingInfo");
                bl = false;
            }
        }
        if (bl) {
            modelInfo = new ModelInfo();
            modelInfo.add("Index.MacAddr", octetString);
            modelInfo.add("Index.VlanIdNum", n3);
            try {
                modelInfo = genModel.getInfo("Panel", "default", modelInfo);
                if (modelInfo.get("Panel.UnicastAddrOperState") instanceof Integer) {
                    if (RAS.isEnabled(19, 7)) {
                        RAS.trace(19, 7, this, string2, "unicast address already exists");
                    }
                    string = new String("UC_already exists");
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string2, "unexcepted bypassable exception");
                }
                RAS.logException(19, 7, this, string2, exception);
            }
        }
        if (bl) {
            modelInfo = new ModelInfo();
            modelInfo.add("Index.MacAddr", octetString);
            modelInfo.add("Index.VlanIdNum", n3);
            modelInfo.add("Panel.UnicastAddrPortNum", n2);
            modelInfo.add("Panel.PhonyAdminStatus", n);
            try {
                modelInfo = genModel.setInfo("Panel", modelInfo);
                bl = this.checkSnmpResponse(modelInfo);
                if (!bl) {
                    string = new String("WZ_badSet");
                }
            }
            catch (Exception exception) {
                bl = false;
                string = new String("WZ_badSet");
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string2, "Exception setting unicast Create data");
                }
                RAS.logException(19, 7, this, string2, exception);
            }
        }
        if (!bl && this.browser != null) {
            this.browser.displayMsg(UnicastAddrCreate.getNLSString(string));
            this.messageToUser = new MessageBox(this.browser.getFrame(), UnicastAddrCreate.getNLSString("UC_error"), UnicastAddrCreate.getNLSString(string), true);
        }
        return bl;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private boolean checkSnmpResponse(ModelInfo modelInfo) {
        boolean bl = false;
        String string = "checkSnmpResponse";
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            bl = true;
            String string2 = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string2);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string, "Error in snmp set. Variable is " + string2 + "  SpecialValue is " + serializable);
            }
            bl = false;
            break;
        }
        return bl;
    }
}

